//: ## Closures
//:
//: Closures are grouped lines of code that can be executed together.
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


// a simple closure
{
    print("Hello")
}

// stored in a variable
let closure: () -> String = {
    print("Hello")
}

// how to execute
closure()

// and execute it again
closure()
closure()


//:
//: -------------------
//:
//: ## Functions are Closures
//:
//: Functions are a special case of named closure.
//:
//: Both use a slightly different syntax.
//:
//: -------------------
//:


// using a function
func greetFunction(person: String) -> String {
    return "Hello \(person),"
}

// using a closure (and storing it within a variable)
let greetClosure: (String) -> String = { person in
    return "Hello \(person),"
}


//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ## ![3 Days Of Swift Logo](3DaysIcon146.png) 3 Days Of Swift 
//:
//: © Copyright. All rights reserved.
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
